/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.settings.user;

import com.ibm.hwmca.base.settings.user.UIStyleBean;
import com.ibm.hwmca.base.settings.user.UserSettingsTasklet;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.User;
import com.ibm.hwmca.fw.settings.user.UIStyleSettings;
import com.ibm.hwmca.fw.settings.user.UserSettingsErrorIds;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.ui.UIStyleManager;
import com.ibm.hwmca.fw.util.Trace;

public class UIStyleTasklet
extends UserSettingsTasklet
implements UserSettingsErrorIds {
    private static final String TRACE_MASKT = "HUSRUIST";
    private static final String TRACE_MASKF = "HUSRUISF";
    private static final String TRACE_MASKD = "HUSRUISD";
    private static final String AUIML_FILE_NAME = "com.ibm.hwmca.base.settings.user.res.UIStyleRes";
    private static final String PANEL_NAME = "UIStylePanel";
    private static final String SETTINGS_CLASS_NAME = "com.ibm.hwmca.fw.settings.user.UIStyleSettings";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "UIStyleTasklet");

    public UIStyleTasklet() {
        super(SETTINGS_CLASS_NAME);
        Trace.trace(TRACE_MASKT, "<> UIStyleTasklet.UIStyleTasklet()");
    }

    protected void serviceInitialRequest(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKF, "-> UIStyleTasklet.serviceInitialRequest()");
        User user = User.getUser();
        UIStyleSettings settings = (UIStyleSettings)user.getUserSettings(SETTINGS_CLASS_NAME);
        UIStyleBean bean = new UIStyleBean();
        bean.setBeanName(SETTINGS_CLASS_NAME);
        bean.setUserSettings(settings);
        UIStyleManager manager = UIStyleManager.getUIStyleManager();
        bean.setUIStyles(manager.getUIStyles());
        if (user.hasAuth("base.rolegroup.acsadmin")) {
            bean.setShowAllowed(true);
        }
        response.replace(AUIML_FILE_NAME, PANEL_NAME, bean);
        Trace.trace(TRACE_MASKF, "<- UIStyleTasklet.serviceInitialRequest()");
    }

    public void logException(Throwable thr) {
        Trace.trace(TRACE_MASKF, "<> UIStyleTasklet.logException(), " + thr);
        thr.printStackTrace();
        new FrameworkLog(classLogInfo, 1994, thr).log();
    }
}

